package gov.va.genisis2.model;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class UserType.
 * 
 * Description: In this UserType Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.User_Type Table in the
 * database.
 *
 */
@Entity
@Table(name = "User_Type", schema = "dbo")
public class UserType implements java.io.Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1L;

	/** The user type id. */
	private int userTypeId;
	/** The user type desc. */
	private String userTypeDesc;
	
	/** The user role types. */
	private Set<UserRoleType> userRoleTypes = new HashSet<>(0);

	/**
	 * Instantiates a new user type.
	 */
	public UserType() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new user type.
	 *
	 * @param userTypeId the user type id
	 * @param userTypeDesc the user type desc
	 */
	public UserType(int userTypeId, String userTypeDesc) {
		this.userTypeId = userTypeId;
		this.userTypeDesc = userTypeDesc;
	}

	/**
	 * Instantiates a new user type.
	 *
	 * @param userTypeId the user type id
	 * @param userTypeDesc the user type desc
	 * @param userRoleTypes the user role types
	 */
	public UserType(int userTypeId, String userTypeDesc, Set<UserRoleType> userRoleTypes) {
		this.userTypeId = userTypeId;
		this.userTypeDesc = userTypeDesc;
		this.userRoleTypes = userRoleTypes;
	}

	/**
	 * Gets the user type id.
	 *
	 * @return the user type id
	 */
	@Id
	@Column(name = "User_Type_id", unique = true, nullable = false)
	public int getUserTypeId() {
		return this.userTypeId;
	}

	/**
	 * Sets the user type id.
	 *
	 * @param userTypeId the new user type id
	 */
	public void setUserTypeId(int userTypeId) {
		this.userTypeId = userTypeId;
	}

	/**
	 * Gets the user type desc.
	 *
	 * @return the user type desc
	 */
	@Column(name = "User_Type_desc", nullable = false, length = 50)
	public String getUserTypeDesc() {
		return this.userTypeDesc;
	}

	/**
	 * Sets the user type desc.
	 *
	 * @param userTypeDesc the new user type desc
	 */
	public void setUserTypeDesc(String userTypeDesc) {
		this.userTypeDesc = userTypeDesc;
	}

	/**
	 * Gets the user role types.
	 *
	 * @return the user role types
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "userType")
	public Set<UserRoleType> getUserRoleTypes() {
		return this.userRoleTypes;
	}

	/**
	 * Sets the user role types.
	 *
	 * @param userRoleTypes the new user role types
	 */
	public void setUserRoleTypes(Set<UserRoleType> userRoleTypes) {
		this.userRoleTypes = userRoleTypes;
	}

}
